<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlanOrderCardsTable extends Migration {

	public function up()
	{
		Schema::create('plan_order_cards', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('plan_order_id')->unsigned();
			$table->integer('stage_id')->unsigned();
			$table->date('date');
			$table->float('duration', 8,2);
			$table->boolean('done');
			$table->integer('assignee_user_id')->unsigned();
			$table->string('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('plan_order_cards');
	}
}