<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStagesTable extends Migration {

	public function up()
	{
		Schema::create('stages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('board_id')->unsigned();
			$table->string('name');
			$table->tinyInteger('priority');
			$table->boolean('stock_notification');
			$table->string('capacity_notification');
			$table->tinyInteger('delay_day');
			$table->boolean('previous_done');
			$table->tinyInteger('efficiency');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('stages');
	}
}