<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->string('username');
			$table->string('password');
			$table->string('firstname');
			$table->string('lastname');
			$table->string('infix');
			$table->string('fullname');
			$table->enum('gender', array('m', 'f', 'o'));
			$table->string('email');
			$table->integer('mobile');
			$table->binary('avatar');
			$table->enum('state', array('active', 'banned', 'blocked'));
			$table->enum('role', array('admin', 'planner', 'worker'));
			$table->timestamps();
			$table->softDeletes();
			$table->rememberToken();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}