<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('employee_schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id')->unsigned();
			$table->enum('type', array('present', 'leave', 'sick'));
			$table->date('date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('employee_schedules');
	}
}