<?php

namespace App\Models;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'image', 'contact_phone', 'contact_whats_app', 'status', 'minimum_charge', 'delivery_fee', 'region_id', 'is_active', 'api_token');

	public function region()
	{
		return $this->belongsTo('App\Models\Region');
	}

	public function products()
	{
		return $this->hasMany('App\Models\Product');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Models\Category');
	}

	public function offers()
	{
		return $this->hasMany('App\Models\Offer');
	}

	public function payments()
	{
		return $this->hasMany('App\Models\Payment');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function notifications()
	{
		return $this->morphMany('App\Models\Notification', 'notifable');
	}

	public function reviwes()
	{
		return $this->hasMany('App\Models\Reviwe');
	}

	public function tokens()
	{
		return $this->morphMany('App\Models\Token', 'tokenable');
	}

}