<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('name_arabic', 191);
			$table->integer('city_id')->unsigned();
			$table->text('address');
			$table->text('designation');
			$table->string('phone', 191);
			$table->string('mobile');
			$table->string('contact_person', 191);
			$table->string('contact_person_no', 191);
			$table->string('trn_no');
			$table->string('email', 191);
			$table->string('credit_limit', 191);
			$table->string('credit_days', 191);
			$table->string('vat_type', 191);
			$table->string('fax_no', 191);
			$table->string('license_no');
			$table->date('license_expay_date');
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}