<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class BloodTypes extends Model 
{

    protected $table = 'blood_types';
    public $timestamps = true;
    protected $fillable = array('name');

    public function clients()
    {
        return $this->belongsToMany('App\Client', 'blood_type_id');
    }

    public function donationRequests()
    {
        return $this->hasMany('App\DonationRequest', 'blood_type_id');
    }

}