<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestesTable extends Migration {

	public function up()
	{
		Schema::create('requestes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('parent_name', 255);
			$table->string('parent_email', 100)->unique();
			$table->string('parent_mobile', 30)->unique();
			$table->date('parent_data_birth');
			$table->string('parent_personal_identification');
			$table->string('parent_national_id', 14)->unique();
			$table->string('parent_address');
			$table->string('paent_job');
			$table->enum('parent_gender', array('male', 'female'));
			$table->string('child_name');
			$table->date('child_date_birth');
			$table->string('child_birth_certificate');
			$table->enum('child_gender', array('male', 'female'));
			$table->enum('child_level', array('1', '2', '3', '4', '5', '6'));
			$table->string('child_school_name')->nullable();
			$table->char('message_otp', 6)->nullable();
			$table->enum('status', array('pending', 'accept', 'reject'));
		});
	}

	public function down()
	{
		Schema::drop('requestes');
	}
}