<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('parent_id')->unsigned();
			$table->string('name');
			$table->string('email');
			$table->date('date_birth');
			$table->enum('gender', array('male', 'female'));
			$table->integer('clesse_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}