<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nom', 'prenom', 'telephone', 'email', 'id_user');
	protected $visible = array('nom', 'prenom', 'telephone', 'email', 'id_user');

	public function ventes()
	{
		return $this->hasMany('App\Models\Vente', 'id_client');
	}

}