<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Fournisseur extends Eloquent {

	protected $table = 'fournisseur';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nom', 'telephone');
	protected $visible = array('nom', 'telephone');

	public function entrees_stock()
	{
		return $this->hasMany('App\Models\Entree_stock', 'id_fournisseur');
	}

}