<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Appointment extends Model 
{

    protected $table = 'appointments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Availability()
    {
        return $this->hasOne('Availability', 'id');
    }

    public function Client()
    {
        return $this->hasOne('Client', 'id');
    }

    public function Service()
    {
        return $this->hasOne('Service', 'id');
    }

    public function byUser()
    {
        return $this->hasOne('User', 'id');
    }

}