<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('domain_id')->unsigned()->index();
			$table->integer('parent_id')->unsigned();
			$table->string('name');
			$table->string('street1');
			$table->string('street2');
			$table->string('postcode');
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->string('email');
			$table->string('telephone');
			$table->text('note');
			$table->string('code');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}