<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFileDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('file_documents', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('file_id')->unsigned();
			$table->string('name');
			$table->string('type');
			$table->binary('contents');
			$table->integer('by_user_id')->unsigned();
			$table->string('hash');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('file_documents');
	}
}