<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('availability_id')->unsigned()->index();
			$table->integer('service_id')->unsigned()->index();
			$table->integer('client_id')->unsigned()->index();
			$table->datetime('start');
			$table->datetime('end');
			$table->text('note');
			$table->integer('by_user_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}