<?php

namespace App\Models;

class Question extends Eloquent {

	protected $table = 'questions';
	public $timestamps = true;

	public function paper()
	{
		return $this->belongsTo('App\Models\Paper');
	}

	public function level()
	{
		return $this->belongsTo('App\Models\QuestionLevel');
	}

	public function questionChoices()
	{
		return $this->hasMany('App\Models\QuestionChoice');
	}

	public function paperAnswers()
	{
		return $this->hasMany('App\Models\PaperAnswers');
	}

}