<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLanguageableTable extends Migration {

	public function up()
	{
		Schema::create('languageable', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('languageable_id')->unsigned()->index();
			$table->string('languageable_type');
			$table->bigInteger('language_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('languageable');
	}
}