<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class GolfClub extends Eloquent {

	protected $table = 'golf_clubs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function slots()
	{
		return $this->hasMany('Slot');
	}

	public function address()
	{
		return $this->morphOne('Address', 'model');
	}

}