<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Reservation extends Eloquent {

	protected $table = 'reservations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function student()
	{
		return $this->belongsTo('Student');
	}

	public function slot()
	{
		return $this->hasOne('Slot');
	}

	public function coach()
	{
		return $this->belongsTo('Coach');
	}

	public function participants()
	{
		return $this->hasMany('Reservation');
	}

	public function videos()
	{
		return $this->hasMany('MediaLibrary');
	}

}