<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Slot extends Eloquent {

	protected $table = 'slots';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function offers()
	{
		return $this->belongsToMany('Offer', 'slot_offer');
	}

	public function golfClub()
	{
		return $this->belongsTo('GolfClub');
	}

	public function recurrence()
	{
		return $this->belongsTo('Recurrence');
	}

}