<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoachesTable extends Migration {

	public function up()
	{
		Schema::create('coaches', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('gender', array('male', 'female', 'other'));
			$table->bigInteger('country_id')->unsigned()->index();
			$table->bigInteger('city_id')->unsigned()->index();
			$table->string('profile_img_path');
			$table->boolean('auto_accept');
			$table->text('description');
			$table->string('name');
			$table->string('lastname');
			$table->string('password');
			$table->string('email');
			$table->timestamps();
			$table->softDeletes();
			$table->bigIncrements('total_revenue');
			$table->bigIncrements('total_analysis');
		});
	}

	public function down()
	{
		Schema::drop('coaches');
	}
}