<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGolfAttributesTable extends Migration {

	public function up()
	{
		Schema::create('golf_attributes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('preferred_grip', array('right', 'left', 'ambidextrous'));
			$table->enum('height', array('left', 'middle', 'right'));
			$table->smallInteger('index');
			$table->smallInteger('game_level_index');
			$table->enum('handicap', array('weak', 'average', 'high'));
			$table->bigInteger('model_id');
			$table->string('model_type');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('golf_attributes');
	}
}