<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('lastname');
			$table->string('email');
			$table->string('password');
			$table->enum('gender', array('male', 'female', 'other'));
			$table->string('profile_img_path');
			$table->bigInteger('country_id')->unsigned()->index();
			$table->bigInteger('city_id')->unsigned()->index();
			$table->text('description');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}