<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBillingDetailTable extends Migration {

	public function up()
	{
		Schema::create('billing_detail', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('email')->nullable();
			$table->string('organization')->nullable();
			$table->string('contact_person')->nullable();
			$table->integer('network_id')->unsigned()->nullable();
			$table->integer('contact_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('billing_detail');
	}
}