<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('registration_no')->nullable();
			$table->string('business_name')->nullable();
			$table->string('alternative_name')->nullable();
			$table->string('email')->nullable();
			$table->string('logo')->nullable();
			$table->integer('contact_id')->unsigned();
			$table->integer('currency_id')->unsigned()->nullable();
			$table->datetime('start_time')->nullable();
			$table->datetime('end_time')->nullable();
			$table->tinyInteger('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}