<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntrantsTable extends Migration {

	public function up()
	{
		Schema::create('entrants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('firstname', 50);
			$table->string('lastname', 50);
			$table->string('city', 50);
			$table->string('email', 50)->unique();
			$table->boolean('newsletter');
		});
	}

	public function down()
	{
		Schema::drop('entrants');
	}
}