<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Topic extends Eloquent {

	protected $table = 'topics';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'content');
	protected $visible = array('title', 'content');

	public function posts()
	{
		return $this->hasManyThrough('App\Answer', 'topic_id', 'id')->orderBy('created_at', 'desc');
	}

	public function tags()
	{
		return $this->hasManyThrough('App\Tag', 'App\TopicTag');
	}

	public function users()
	{
		return $this->hasManyThrough('App\User', 'App\UserTopic');
	}

}