<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_id')->default('0');
			$table->integer('category_id')->default('0');
			$table->string('slug');
			$table->string('title');
			$table->string('description');
			$table->text('content');
			$table->string('image');
			$table->string('url');
			$table->integer('gallery_id')->default('0');
			$table->integer('slider_id')->default('0');
			$table->enum('lang', array('tr', 'en', 'ar'));
			$table->enum('noindex', array('y', 'n'));
			$table->string('canonical');
			$table->enum('status', array('active', 'passive'));
			$table->integer('user_id')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}