<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSliderCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('slider_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_id')->default('0');
			$table->string('name');
			$table->integer('width')->default('0');
			$table->integer('height')->default('0');
			$table->enum('status', array('active', 'passive'));
			$table->integer('user_id')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('slider_categories');
	}
}