<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

	public function companyUses()
	{
		return $this->hasMany('CompanyProductUse', 'product_id');
	}

}