<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function citoUseLog()
	{
		return $this->hasOne('CompanyCitoUselog', 'ticket_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

	public function department()
	{
		return $this->belongsTo('Department', 'department_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function creator()
	{
		return $this->hasOne('User', 'creator_id');
	}

	public function assignee()
	{
		return $this->hasOne('User', 'assignee_id');
	}

	public function assigneeCompany()
	{
		return $this->hasOne('Company', 'assignee_company_id');
	}

	public function assigneeLog()
	{
		return $this->hasMany('RequestAssigneeLog', 'ticket_id');
	}

	public function progressionLog()
	{
		return $this->hasMany('RequestProgressionlog', 'ticket_id');
	}

	public function product()
	{
		return $this->hasOne('Product', 'product_id');
	}

	public function tasks()
	{
		return $this->hasMany('Task', 'request_id');
	}

	public function status()
	{
		return $this->hasOne('Status', 'progress_status_id');
	}

	public function activities()
	{
		return $this->hasMany('RequestActivityLog', 'request_id');
	}

}