<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function userInfo()
	{
		return $this->hasOne('UserInfo', 'user_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function ticket()
	{
		return $this->hasMany('Request', 'user_id');
	}

}