<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('company_id')->unsigned();
			$table->bigInteger('department_id')->unsigned();
			$table->bigInteger('category_id')->unsigned();
			$table->bigInteger('creator_id')->unsigned();
			$table->bigInteger('assignee_company_id')->unsigned()->nullable();
			$table->bigInteger('assignee_id')->unsigned()->nullable();
			$table->bigInteger('product_id')->unsigned();
			$table->integer('progress_status_id')->unsigned();
			$table->boolean('is_cito')->default(FALSE);
			$table->float('rating')->nullable();
			$table->string('number');
			$table->enum('priority', array('low', 'medium', 'high'))->nullable();
			$table->text('description')->nullable();
			$table->string('step')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}