<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->tinyInteger('block')->default('1');
			$table->integer('user_id')->unsigned();
			$table->integer('parent_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}